 ; Ŀ
 ;   Coil - attach a "Coil and tape X spares" block and text to a line.    
 ;   Copyright 1997, 2010 by Rocket Software Ltd.                          
 ;   Toasters - the last appliance with no electronics.                    
 ;   Later note: even toasters had to succumb eventually.                  
 ; 

 ; Ŀ
 ;   Tangle - an error handler.                                            
 ; 
 (DEFUN TANGLE (shk /)
  (setq *error* esav)
  (if clay (setvar "clayer" clay))
 (princ))
 ; Ŀ
 ;   Tangle end.                                                           
 ; 

 ; Ŀ
 ;   Spart - insert text, call ddedit.                                     
 ;   Takes three arguments: the angle, insertion point, and scale.         
 ; 
 (DEFUN SPART (angg pa scal)
  (if (tblsearch "layer" "text")
      (setvar "clayer" "text")
      (command "layer" "m" "text" "c" "1" "" ""))
  (cond ((or (>= angg (* pi 1.75)) (< angg (* pi 0.25))) ; right
         (setq pa (polar pa 0 (* scal 5)))
         (command "text" "ml" pa (* 2.5 scal) "" "COIL AND TAPE")
         (command "text" "" "XXX SPARES"))
        ((and (> angg (* pi 0.25)) (<= angg (* pi 0.75))) ; top
         (setq pa (polar pa (/ pi 2) (* scal 9)))
         (command "text" "c" pa (* 2.5 scal) "" "COIL AND TAPE")
         (command "text" "" "XXX SPARES"))
        ((and (> angg (* pi 0.75)) (<= angg (* pi 1.25))) ; left
 ;       (command "mirror" "l" "" pa (polar pa 0 1) "y")
         (setq pa (polar pa pi (* scal 5)))
         (setq pa (polar pa (* pi 0.5) (* scal 4)))
         (command "text" "mr" pa (* 2.5 scal) "" "COIL AND TAPE")
         (command "text" "" "XXX SPARES"))
        ((and (>= angg (* pi 1.25)) (< angg (* pi 1.75))) ; down
         (setq pa (polar pa (* pi 1.5) (* scal 7.5)))
         (command "text" "c" pa (* 2.5 scal) "" "COIL AND TAPE")
         (command "text" "" "XXX SPARES")))
 ; (command "ddedit" "l")
 ; (command)
 (princ))

 ; Ŀ
 ;   Coil.                                                                 
 ; 
 (DEFUN C:COIL (/ scal pa pb ss typ entt enam clay ten elv rota rrota ptlist
                                                                         rrr)
  (setvar "cmdecho" 0)
  (command "undo" "m")
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq scal (misps))
  (if (zerop scal) (setq scal 1))
 ; Ŀ
 ;   Ask for an insertion point, see if there is an entity.                
 ; 
  (if (and (setq pa (getpoint "Point near or on wire end: "))
           (setq pb (osnap pa "Nearest"))
           (if pb (setq pa pb)))
      (setq ss (ssget pa)))
 ; Ŀ
 ;   If an entity was found, see what type it was.                         
 ; 
  (if ss
     (progn
          (setq typ (cdr (assoc 0 (setq entt (entget
                                               (setq enam (ssname ss 0)))))))
          (setq clay (getvar "clayer"))
          (setvar "clayer" (cdr (assoc 8 entt)))
 ; Ŀ
 ;   Put an entity on a line: find the end closest to the pick point,      
 ;   get angle etc., install block.                                        
 ; 
          (cond ((= typ "LINE")
                 (setq ten (cdr (assoc 10 entt)))
                 (setq elv (cdr (assoc 11 entt)))
                 (if (< (distance pa ten) (distance pa elv))
                     (progn
                          (setq rota (angle elv ten))
                          (setq pa ten))
                     (progn
                          (setq rota (angle ten elv))
                          (setq pa elv)))
                 (setq rrota (/ (* 180 rota) pi))
                 (command "insert" "coil" pa scal "" rrota)
                 (spart rota pa scal))
 ; Ŀ
 ;   If the entity is a pline, see if the pick point is on one end of the  
 ;   current segment.  If so then must find the segment to get both        
 ;   endpoints and thus the angle.                                         
 ; 
                ((= typ "POLYLINE")
                 (setq pb (osnap pa "endpoint"))
                 (if (equal pb pa) ; then it's at one end of the pline
 ; Ŀ
 ;   So: a sub Cond: see if the pick point is at the start of the          
 ;   polyline.                                                             
 ; 
                     (cond ((equal pa (cdr (assoc 10 (entget (entnext enam)))))
                            (setq pb (cdr (assoc 10 (entget (entnext enam)))))
                            (setq rota (angle pb pa))
                            (setq rrota (/ (* 180 rota) pi))
                            (command "insert" "coil" pa scal "" rrota)
                            (spart rota pa scal))
 ; Ŀ
 ;   Sub Cond default: The pick point isn't on the first vertex so it is   
 ;   taken to be on the last one, since there seems to be little reason    
 ;   to attach a block in the middle of a polyline.                        
 ; 
                           (t
                            (while (/= (cdr (assoc 0 (setq entt (entget (setq
                                            enam (entnext enam)))))) "SEQEND")
                                   (setq ptlist (append ptlist
                                                (list (cdr (assoc 10 entt))))))
                            (setq ptlist (reverse ptlist))
                            (setq pa (car ptlist))
                            (setq pb (cadr ptlist))
                            (setq rota (angle pb pa))
                            (setq rrota (/ (* 180 rota) pi))
                            (command "insert" "coil" pa scal "" rrota)
                            (spart rota pa scal)))
 ; Ŀ
 ;   The point on the polyline wasn't a vertex, so the enpoint was         
 ;   different and an angle can be calculated.                             
 ; 
                     (progn
                          (setq rota (angle pa pb))
                          (setq rrota (/ (* 180 rota) pi))
                          (command "insert" "coil" pb scal "" rrota)
                          (spart rota pb scal)))))
          (setvar "clayer" clay))
 ; Ŀ
 ;   No entity was found at the point, so ask for an angle and put the     
 ;   block there.                                                          
 ; 
     (if pa
        (progn
             (if (/= (type rrota) 'REAL) (setq rrota 0.0))
             (setq rrr (getangle pa (strcat "\nInsertion angle <"
                                                    (rtos rrota 2 2) ">: ")))
             (if rrr (setq rrota (/ (* 180 rrr) pi)))
             (command "insert" "coil" pa scal "" rrota)
             (setq rota (* (/ rrota 180) pi))
             (spart rota pa scal))))
 (princ))